function collect_spell_info( slot : string, out text : string ) : bool
{
	var spell_name, spell_name2 : name; var signskill:ESkill; var alternate:bool; var act_signtype:ESignType; var alt:int; var state_n:name;
	
	var damage, elem_dmg, frost_dmg, poison_dmg, direct_dmg, shock_dmg, force_dmg, bleeding, poison, modifier, fire_dmg 		: string;
	var modifier_proj, modifier_trap, modifier_wave, modifier_stream, modifier_wavefar, modifier_trapspec, modifier_blast     	: string;
	var modifier_meteors, modifier_iceblast, modifier_meteors_quil, modifier_storm, damage_decrease, chance, burning, ret_text	: string;
	var i 													: int;
	var tier1												: bool;
	var item_name_quick 									: name;
	var fontItemName, fontDamage							: string;
	var aiming_spells										: array<name>;
	var result, show_quick, show_trophy, res				: bool;

	result = false;

	damage    				= GetLocStringByKeyExt( "spells_damages_damage" )   			;
	elem_dmg  				= GetLocStringByKeyExt( "spells_elemental_damage" ) 			;
	fire_dmg 				= GetLocStringByKeyExt( "spells_fire_damage" )      			;
	frost_dmg 				= GetLocStringByKeyExt( "spells_frost_damage" )     			;
	poison_dmg  			= GetLocStringByKeyExt( "spells_poison_damage" )    			;
	direct_dmg  			= GetLocStringByKeyExt( "spells_direct_damage" )    			;
	shock_dmg 				= GetLocStringByKeyExt( "spells_shock_damage" )     			;
	force_dmg 				= GetLocStringByKeyExt( "spells_force_damage" )					;
	bleeding				= GetLocStringByKeyExt( "effect_bleeding" )						;
	poison					= GetLocStringByKeyExt( "attribute_name_poison" )				;
	burning					= GetLocStringByKeyExt( "spells_burning_descr" )				;
	modifier				= GetLocStringByKeyExt( "spells_modifier" )						;	
	modifier_proj			= GetLocStringByKeyExt( "spells_modifier_projectile" )			;	
	modifier_trap			= GetLocStringByKeyExt( "spells_modifier_trap" )				;	
	modifier_wave			= GetLocStringByKeyExt( "spells_modifier_wave" )				;	
	modifier_stream			= GetLocStringByKeyExt( "spells_modifier_stream" )				;	
	modifier_wavefar		= GetLocStringByKeyExt( "spells_modifier_wave_far" )			;	
	modifier_trapspec		= GetLocStringByKeyExt( "spells_modifier_trap_spec" )			;	
	modifier_blast			= GetLocStringByKeyExt( "spells_modifier_blast" )				;	
	modifier_meteors		= GetLocStringByKeyExt( "spells_modifier_meteors" )				;	
	modifier_iceblast		= GetLocStringByKeyExt( "spells_modifier_iceblast" )			;	
	modifier_meteors_quil	= GetLocStringByKeyExt( "spells_modifier_meteors_quileg" )		;	
	modifier_storm			= GetLocStringByKeyExt( "spells_modifier_storm" )				;	
	damage_decrease    		= GetLocStringByKeyExt( "spells_less_damage" )   				;
	chance    				= GetLocStringByKeyExt( "spells_chance" )   					;
	

	fontItemName = "<font size=\"26\" color=\"#034077\">";
	fontDamage = "<font size=\"21\">";

	item_name_quick = GetMagicVigil().magic_item_quickslot_name;
	
	if ( get_magic_item_quickslot() != 'empty' )
	{
		item_name_quick = get_magic_item_quickslot();
	}
	
	if ( item_name_quick != 'empty' && GetWitcherPlayer().IsItemEquippedByName( item_name_quick ) && item_name_quick != 'None' ) 
	{
		tier1 = true;
	}
	
	//text += slot;
	
	if ( slot == "QuickSlot" )
	{
		check_ma_spells();
		aiming_spells = GetMagicVigil().manual_aim_spells;
		if ( aiming_spells.Size()>0 && tier1 )
		{
			result = true;
		
			//text += fontItemName + GetLocStringByKeyExt( "spells_manual_aiming_descr" ) + ":" + "</font>";
			text += "<font face=\"$BoldFont\">" + GetLocStringByKeyExt( "spells_manual_aiming_descr" ) +":" + "</font>";
							text += "<br/>   " + fontDamage
									+ GetLocStringByKeyExt( "spells_modifier_all" ) + ": "
									+ GetLocStringByKeyExt( "spells_manual_aiming_descr" )
									+ "." + "</font>";
			
			for( i=0; i<aiming_spells.Size(); i+=1 )
			{
				switch( aiming_spells[i] )
				{
					case 'stone_proj_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_stone_projectile" ) + "</font>";
							text += ". " + GetLocStringByKeyExt( "spells_one_target" ) + ".";
							text += "<br/>" + fontDamage + "" 
									+ damage + ": " 
									+ elem_dmg
									+ ".";
							text += "<br/>"
									+ modifier + ": "
									+ modifier_proj
									+ "." + "</font>";
						}
						break;
					case 'fire_granade_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_fireentity_projectile" ) + "</font>";
							text += ". " + GetLocStringByKeyExt( "spells_small_radius" ) + ".";
							text += "<br/>" + fontDamage + "" 
									+ damage + " " + damage_decrease + ": " 
									+ fire_dmg
									+ "."
									+ " " + chance + ": "
									+ burning
									+ ".";
							text += "<br/>"
									+ modifier + ": "
									+ modifier_proj
									+ "." + "</font>";
						}
						break;
					case 'ice_spear_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_iceentity_projectile" ) + "</font>";
							text += ". " + GetLocStringByKeyExt( "spells_pierce_target" ) + ".";
							text += "<br/>" + fontDamage + "" 
									+ damage + ": " 
									+ elem_dmg + ", "
									+ frost_dmg
									+ ".";
							text += "<br/>"
									+ modifier + ": "
									+ modifier_proj
									+ "." + "</font>";
						}
						break;
					case 'gnosis_fireball_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_fire_gnosis_fireball" ) + "</font>";
							text += ". " + GetLocStringByKeyExt( "spells_near_targets" ) + ".";
							text += "<br/>" + fontDamage + "" 
									+ damage + " " + damage_decrease + ": " 
									+ fire_dmg
									+ "."
									+ " " + chance + ": "
									+ burning
									+ ".";
							text += "<br/>"
									+ modifier + ": "
									+ modifier_proj
									+ "." + "</font>";
						}
						break;
					case 'gnosis_trap_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_fire_gnosis_trap" ) + "</font>";
							//text += ". " + GetLocStringByKeyExt( "spells_fire_gnosis_trap_descr" ) + ".";
							text += "<br/>" + fontDamage + "" 
									+ damage + ": " 
									+ fire_dmg
									+ ".";
							text += "<br/>"
									+ modifier + ": "
									+ modifier_trap
									+ "." + "</font>";
						}
						break;
					case 'swamp_fireball_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_great_swamp_venom" ) + "</font>";
							//text += ". " + GetLocStringByKeyExt( "spells_great_swamp_venom_descr" ) + ".";
							text += ". " + GetLocStringByKeyExt( "spells_one_target" );
							text += "<br/>" + fontDamage + "" 
									+ damage + ": " 
									+ poison_dmg + ", "
									+ poison
									+ ".";
							text += "<br/>"
									+ modifier + ": "
									+ modifier_proj
									+ "." + "</font>";
						}
						break;
					case 'swamp_trap_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_great_swamp_trap" ) + "</font>";
							//text += ". " + GetLocStringByKeyExt( "spells_great_swamp_trap_descr" ) + ".";
							text += "<br/>" + fontDamage + "" 
									+ damage + ": " 
									+ poison_dmg + ", "
									+ fire_dmg
									+ ".";
							text += "<br/>"
									+ modifier + ": "
									+ modifier_trap
									+ "." + "</font>";
						}
						break;
					case 'frost_ball_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_permafrost_spear" ) + "</font>";
							text += ". " + GetLocStringByKeyExt( "spells_small_radius" ) + ".";
							text += "<br/>" + fontDamage + "" 
									+ damage + " " + damage_decrease + ": " 
									+ frost_dmg + ". "
									+ chance + ": "
									+ GetLocStringByKeyExt( "SlowdownEffect" )
									+ ".";
							text += "<br/>"
									+ modifier + ": "
									+ modifier_proj
									+ "." + "</font>";
						}
						break;
					case 'frost_trap_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_permafrost_trap" ) + "</font>";
							//text += ". " + GetLocStringByKeyExt( "spells_permafrost_trap_descr" ) + ".";
							text += "<br/>" + fontDamage + "" 
									+ damage + ": " 
									+ frost_dmg
									+ ".";
							text += "<br/>"
									+ modifier + ": "
									+ modifier_trap
									+ "." + "</font>";
						}
						break;
					case 'black_ball_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_black_fire_projectile" ) + "</font>";
							text += ". " + GetLocStringByKeyExt( "spells_small_radius" ) + ".";
							text += "<br/>" + fontDamage + "" 
									+ damage + " " + damage_decrease + ": " 
									+ elem_dmg + ", "
									+ fire_dmg + ", "
									+ GetLocStringByKeyExt( "SlowdownEffect" )
									+ ".";
							text += "<br/>"
									+ modifier + ": "
									+ modifier_proj
									+ "." + "</font>";
						}
						break;
					case 'black_trap_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_black_fire_trap" ) + "</font>";
							//text += ". " + GetLocStringByKeyExt( "spells_black_fire_trap_descr" ) + ".";
							text += "<br/>" + fontDamage + "" 
									+ damage + ": " 
									+ direct_dmg
									+ ".";
							text += "<br/>"
									+ modifier + ": "
									+ modifier_trapspec
									+ "." + "</font>";
						}
						break;
					case 'energy_mine_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_energy_mine" ) + "</font>";
							text += ". " + GetLocStringByKeyExt( "spells_small_radius" ) + ".";
							text += "<br/>" + fontDamage + "" 
									+ damage + " " + damage_decrease + ": " 
									+ shock_dmg + ", "
									+ GetLocStringByKeyExt( "effect_confusion" )
									+ ".";
							text += "<br/>"
									+ modifier + ": "
									+ modifier_proj
									+ "." + "</font>";
						}
						break;
					case 'gwin_ball_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_sunspear" ) + "</font>";
							text += ". " + GetLocStringByKeyExt( "spells_small_radius" ) + ".";
							text += "<br/>" + fontDamage + "" 
									+ damage + " " + damage_decrease + ": " 
									+ shock_dmg + ", "
									+ fire_dmg
									+ ".";
							text += "<br/>"
									+ modifier + ": "
									+ modifier_proj
									+ "." + "</font>";
						}
						break;
					case 'gwin_heavy_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_gwin_heavy" ) + "</font>";
							text += ". " + GetLocStringByKeyExt( "spells_pierce_target" ) + ".";
							text += "<br/>" + fontDamage + "" 
									+ damage + " " + damage_decrease + ": "
									+ shock_dmg
									+ ".";
							text += "<br/>"
									+ modifier + ": "
									+ modifier_proj
									+ "." + "</font>";
						}
						break;
					case 'winter_mine_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_winter_mine" ) + "</font>";
							text += ". " + GetLocStringByKeyExt( "spells_small_radius" ) + ".";
							text += "<br/>" + fontDamage + "" 
									+ damage + " " + damage_decrease + ": " 
									+ frost_dmg + ". "
									+ chance + ": "
									+ GetLocStringByKeyExt( "spells_frozen_descr" )
									+ ".";
							text += "<br/>"
									+ modifier + ": "
									+ modifier_proj
									+ "." + "</font>";
						}
						break;
					case 'winter_heavy_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_winter_heavy" ) + "</font>";
							text += ". " + GetLocStringByKeyExt( "spells_pierce_target" ) + ".";
							text += "<br/>" + fontDamage + "" 
									+ damage + " " + damage_decrease + ": "
									+ frost_dmg
									+ "."
									+ " " + chance + ": "
									+ GetLocStringByKeyExt( "spells_frozen_descr" )
									+ ".";
							text += "<br/>"
									+ modifier + ": "
									+ modifier_proj
									+ "." + "</font>";
						}
						break;
					case 'quileg_mine_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_quileg_mine" ) + "</font>";
							text += ". " + GetLocStringByKeyExt( "spells_small_radius" ) + ".";
							text += "<br/>" + fontDamage + "" 
									+ damage + " " + damage_decrease + ": " 
									+ fire_dmg + ", "
									+ GetLocStringByKeyExt( "spells_knockdown_descr" )
									+ ".";
							text += "<br/>"
									+ modifier + ": "
									+ modifier_proj
									+ "." + "</font>";
						}
						break;
					case 'quileg_heavy_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_quileg_heavy" ) + "</font>";
							text += ". " + GetLocStringByKeyExt( "spells_pierce_target" ) + ".";
							text += "<br/>" + fontDamage + "" 
									+ damage + ": " 
									+ fire_dmg
									+ "."
									+ " " + chance + ": "
									+ burning
									+ ".";
							text += "<br/>"
									+ modifier + ": "
									+ modifier_proj
									+ "." + "</font>";
						}
						break;
					case 'assassin_bolt_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_assassin_bolt" ) + "</font>";
							text += ". " + GetLocStringByKeyExt( "spells_assassin_bolt_descr" );
							text += ". " + GetLocStringByKeyExt( "spells_pierce_target" ) + ".";
							text += "<br/>" + fontDamage + "" 
									+ damage + ": " 
									+ direct_dmg
									+ "."
									+ " " + chance + ": "
									+ GetLocStringByKeyExt( "effect_bleeding" ) + ", "
									+ GetLocStringByKeyExt( "attribute_name_poison" )
									+ "." + "</font>";
						}
						break;
					case 'assassin_whirl_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_assassin_whirl" ) + "</font>";
							text += ". " + GetLocStringByKeyExt( "spells_pierce_target" ) + ".";
							//text += "<br/>" + fontDamage + "   " 
							text += "<br/>" + fontDamage + "" 
									+ damage + " " + damage_decrease + ": "
									+ force_dmg
									+ "."
									+ " " + chance + ": "
									+ GetLocStringByKeyExt( "spells_knockdown_descr" )
									+ ".";
							text += "<br/>"
							//text += "<br/>   "
									+ modifier + ": "
									+ modifier_proj
									+ "." + "</font>";
						}
						break;
					case 'vampire_fence_aim':
						{
							text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_vampire_fence" ) + "</font>";
							text += ". " + GetLocStringByKeyExt( "spells_vampire_fence_descr" ) + ".";
						}
						break;
					default:		
						break;
				}
			}
		}
	}
	else
	{
		if ( Spells_get_spell_info( item_name_quick, spell_name, signskill, alternate, act_signtype, alt, state_n, slot, true ) && tier1 )
		{
		
			text += "<font face=\"$BoldFont\">" + GetLocStringByKeyExt( "spells_cast_spell" ) +":" + "</font>";
			text += "<br/>";
			
			res = get_spellinfo_byname( spell_name, ret_text );
			if ( !res )
			{
				res = get_spellinfo_byname2( spell_name, ret_text );
			}
			
			if ( !res )
			{
				res = get_spellinfo_byname3( spell_name, ret_text );
			}
			
			if ( res )
			{
				text += ret_text; 
				show_quick = true;
			}
			
			ret_text = "";
		}
		if ( Spells_get_spell_info_trophy( get_magic_item_trophy(), spell_name2, signskill, alternate, act_signtype, alt, state_n, slot, true ) )
		{
			
			show_trophy = true;
			if ( show_quick )
			{
				text += "<br/><br/>";
			}
			text += "<font face=\"$BoldFont\">" + GetLocStringByKeyExt( "spells_cast_spell_hold" ) +":" + "</font>";
			text += "<br/>";
			
			res = get_spellinfo_byname( spell_name2, ret_text );
			if ( !res )
			{
				res = get_spellinfo_byname2( spell_name2, ret_text );
			}
			
			if ( !res )
			{
				res = get_spellinfo_byname3( spell_name2, ret_text );
			}
			
			if ( res )
			{
				text += ret_text; 
			}
			
			ret_text = "";
		}
		
		if ( thePlayer.HasBuff( EET_LukatielSword ) )
		{
			get_spellinfo_lukatiel( slot, ret_text );
			text += ret_text; 
		}
	}
	
	if ( slot == "none" )
	{
		text = "";
	}
	
	/*
	if ( tier1 )
	{
	}
	
	if ( slot == "Yrden" )
	{		
	}
	
	
		
	if ( show_quick )
	{
		text += "<br/>" + fontItemName + GetLocStringByKeyExt( "spells_vampire_fence" ) + "</font>";
	}
	
	*/
	
	
	
	
	
	return result;
	
	
	
}

function get_spellinfo_byname( spellname : name, out text : string ) : bool
{
	var damage, elem_dmg, frost_dmg, poison_dmg, direct_dmg, shock_dmg, force_dmg, bleeding, poison, modifier, fire_dmg 		: string;
	var modifier_proj, modifier_trap, modifier_wave, modifier_stream, modifier_wavefar, modifier_trapspec, modifier_blast     	: string;
	var modifier_meteors, modifier_iceblast, modifier_meteors_quil, modifier_storm, damage_decrease, chance, burning   			: string;
	var modifier_shield, sword_attack																					: string;
	var i 									: int;
	var item_name_quick 					: name;
	var fontItemName, fontDamage			: string;
	var xbow_name							: string;
	var found 								: bool;

	found = true;

	fontItemName = "<font size=\"26\" color=\"#034077\">";
	fontDamage = "<font size=\"21\">";

	damage    				= GetLocStringByKeyExt( "spells_damages_damage" )   			;
	elem_dmg  				= GetLocStringByKeyExt( "spells_elemental_damage" ) 			;
	fire_dmg 				= GetLocStringByKeyExt( "spells_fire_damage" )      			;
	frost_dmg 				= GetLocStringByKeyExt( "spells_frost_damage" )     			;
	poison_dmg  			= GetLocStringByKeyExt( "spells_poison_damage" )    			;
	direct_dmg  			= GetLocStringByKeyExt( "spells_direct_damage" )    			;
	shock_dmg 				= GetLocStringByKeyExt( "spells_shock_damage" )     			;
	force_dmg 				= GetLocStringByKeyExt( "spells_force_damage" )					;
	bleeding				= GetLocStringByKeyExt( "effect_bleeding" )						;
	poison					= GetLocStringByKeyExt( "attribute_name_poison" )				;
	burning					= GetLocStringByKeyExt( "spells_burning_descr" )				;
	modifier				= GetLocStringByKeyExt( "spells_modifier" )						;	
	modifier_proj			= GetLocStringByKeyExt( "spells_modifier_projectile" )			;	
	modifier_trap			= GetLocStringByKeyExt( "spells_modifier_trap" )				;	
	modifier_wave			= GetLocStringByKeyExt( "spells_modifier_wave" )				;	
	modifier_stream			= GetLocStringByKeyExt( "spells_modifier_stream" )				;	
	modifier_wavefar		= GetLocStringByKeyExt( "spells_modifier_wave_far" )			;	
	modifier_trapspec		= GetLocStringByKeyExt( "spells_modifier_trap_spec" )			;	
	modifier_blast			= GetLocStringByKeyExt( "spells_modifier_blast" )				;	
	modifier_meteors		= GetLocStringByKeyExt( "spells_modifier_meteors" )				;	
	modifier_iceblast		= GetLocStringByKeyExt( "spells_modifier_iceblast" )			;	
	modifier_meteors_quil	= GetLocStringByKeyExt( "spells_modifier_meteors_quileg" )		;	
	modifier_storm			= GetLocStringByKeyExt( "spells_modifier_storm" )				;	
	damage_decrease    		= GetLocStringByKeyExt( "spells_less_damage" )   				;
	chance    				= GetLocStringByKeyExt( "spells_chance" )   					;
	modifier_shield			= GetLocStringByKeyExt( "spells_modifier_shield" )				;	
	sword_attack			= GetLocStringByKeyExt( "spells_modifier_sword_attack" )		;

	switch( spellname )
	{
		case 'black_fire_trap':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_black_fire_trap" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_black_fire_trap_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ direct_dmg
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_trapspec
						+ "." + "</font>";
			}
			break;
		case 'black_fire_shield':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_black_fire_shield" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_black_fire_shield_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ elem_dmg + ", "
						+ fire_dmg
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_shield
						+ "." + "</font>";
			}
			break;
		case 'black_fire_stream':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_black_fire_stream" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_black_fire_stream_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ elem_dmg + ", "
						+ fire_dmg + ", "
						+ GetLocStringByKeyExt( "SlowdownEffect" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_stream
						+ "." + "</font>";
			}
			break;
		case 'black_fire_projectile':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_black_fire_projectile" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_black_fire_projectile_descr" ) + ".";
				text += "<br/>" + GetLocStringByKeyExt( "spells_small_radius" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + " " + damage_decrease + ": " 
						+ elem_dmg + ", "
						+ fire_dmg + ", "
						+ GetLocStringByKeyExt( "SlowdownEffect" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_proj
						+ "." + "</font>";
			}
			break;
		case 'black_fire_cone':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_black_fire_cone" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_black_fire_cone_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ elem_dmg + ", "
						+ fire_dmg + ", "
						+ GetLocStringByKeyExt( "SlowdownEffect" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_wave
						+ "." + "</font>";
			}
			break;
		case 'fire_gnosis_trap':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_fire_gnosis_trap" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_fire_gnosis_trap_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ fire_dmg
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_trap
						+ "." + "</font>";
			}
			break;
		case 'fire_gnosis_stream':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_fire_gnosis_stream" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_fire_gnosis_stream_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ fire_dmg
						+ "."
						+ "<br/>" + chance + ": "
						+ burning
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_stream
						+ "." + "</font>";
			}
			break;
		case 'fire_gnosis_fireball':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_fire_gnosis_fireball" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_fire_gnosis_fireball_descr" ) + ".";
				text += "<br/>" + GetLocStringByKeyExt( "spells_near_targets" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + " " + damage_decrease + ": " 
						+ fire_dmg
						+ "."
						+ "<br/>" + chance + ": "
						+ burning
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_proj
						+ "." + "</font>";
			}
			break;
		case 'fire_gnosis_cone':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_fire_gnosis_cone" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_fire_gnosis_cone_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ fire_dmg
						+ "."
						+ "<br/>" + chance + ": "
						+ burning
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_wavefar
						+ "." + "</font>";
			}
			break;
		case 'permafrost_trap':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_permafrost_trap" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_permafrost_trap_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ frost_dmg
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_trap
						+ "." + "</font>";
			}
			break;
		case 'permafrost_spear':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_permafrost_spear" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_permafrost_spear_descr" ) + ".";
				text += "<br/>" + GetLocStringByKeyExt( "spells_small_radius" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + " " + damage_decrease + ": " 
						+ frost_dmg + ".<br/>"
						+ chance + ": "
						+ GetLocStringByKeyExt( "SlowdownEffect" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_proj
						+ "." + "</font>";
			}
			break;
		case 'permafrost_cone':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_permafrost_cone" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_permafrost_cone_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ frost_dmg + ".<br/>"
						+ chance + ": "
						+ GetLocStringByKeyExt( "SlowdownEffect" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_wavefar
						+ "." + "</font>";
			}
			break;
		case 'stone_golem':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_stone_golem" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_stone_golem_descr" ) + ".";
			}
			break;
		case 'stone_line':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_stone_line" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_stone_line_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ elem_dmg + ", "
						+ GetLocStringByKeyExt( "spells_knockdown_descr" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_wavefar
						+ "." + "</font>";
			}
			break;
		case 'stone_projectile':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_stone_projectile" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_stone_projectile_descr" ) + ".";
				text += "<br/>" + GetLocStringByKeyExt( "spells_one_target" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ elem_dmg
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_proj
						+ "." + "</font>";
			}
			break;
		case 'stone_area':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_stone_area" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_stone_area_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ elem_dmg
						+ ".<br/>"
						+ chance + ": "
						+ GetLocStringByKeyExt( "spells_knockdown_descr" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_wavefar
						+ "." + "</font>";
			}
			break;
		case 'ice_golem':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_ice_golem" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_ice_golem_descr" ) + ".";
			}
			break;
		case 'ice_line':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_ice_line" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_ice_line_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ elem_dmg + ", "
						+ frost_dmg + ", "
						+ GetLocStringByKeyExt( "spells_knockdown_descr" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_wavefar
						+ "." + "</font>";
			}
			break;
		case 'iceentity_projectile':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_iceentity_projectile" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_iceentity_projectile_descr" ) + ".";
				text += "<br/>" + GetLocStringByKeyExt( "spells_pierce_target" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ elem_dmg + ", "
						+ frost_dmg
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_proj
						+ "." + "</font>";
			}
			break;
		case 'ice_area':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_ice_area" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_ice_area_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ frost_dmg
						+ ".<br/>"
						+ chance + ": "
						+ GetLocStringByKeyExt( "spells_frozen_descr" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_wavefar
						+ "." + "</font>";
			}
			break;
		case 'fire_golem':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_fire_golem" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_fire_golem_descr" ) + ".";
			}
			break;
		case 'fire_line':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_fire_line" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_fire_line_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ fire_dmg
						+ "."
						+ "<br/>" + chance + ": "
						+ burning
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_wavefar
						+ "." + "</font>";
			}
			break;
		case 'fireentity_projectile':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_fireentity_projectile" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_fireentity_projectile_descr" ) + ".";
				text += "<br/>" + GetLocStringByKeyExt( "spells_small_radius" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + " " + damage_decrease + ": " 
						+ fire_dmg
						+ "."
						+ "<br/>" + chance + ": "
						+ burning
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_proj
						+ "." + "</font>";
			}
			break;
		case 'fire_area':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_fire_area" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_fire_area_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ fire_dmg
						+ "."
						+ "<br/>" + chance + ": "
						+ burning
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_wavefar
						+ "." + "</font>";
			}
			break;
		case 'great_swamp_trap':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_great_swamp_trap" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_great_swamp_trap_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ poison_dmg + ", "
						+ fire_dmg
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_trap
						+ "." + "</font>";
			}
			break;
		case 'great_swamp_stream':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_great_swamp_stream" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_great_swamp_stream_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ poison_dmg + ", "
						+ fire_dmg + ", "
						+ GetLocStringByKeyExt( "SlowdownEffect" )
						+ "."
						+ "<br/>" + chance + ": "
						+ poison
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_stream
						+ "." + "</font>";
			}
			break;
		case 'great_swamp_venom':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_great_swamp_venom" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_great_swamp_venom_descr" ) + ".";
				text += "<br/>" + GetLocStringByKeyExt( "spells_one_target" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ poison_dmg + ", "
						+ poison
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_proj
						+ "." + "</font>";
			}
			break;
		case 'great_swamp_cone':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_great_swamp_cone" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_great_swamp_cone_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ poison_dmg + ", "
						+ fire_dmg
						+ "."
						+ "<br/>" + chance + ": "
						+ poison
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_wavefar
						+ "." + "</font>";
			}
			break;
		case 'energy_circle':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_energy_circle" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_energy_circle_descr" ) + ".";
				text += "<br/>" + fontDamage + ""
						+ modifier + ": "
						+ sword_attack
						+ "." + "</font>";
			}
			break;
		case 'energy_shield':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_energy_shield" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_energy_shield_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ shock_dmg
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_shield
						+ "." + "</font>";
			}
			break;
		case 'energy_stream':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_energy_stream" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_energy_stream_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ shock_dmg + ", "
						+ GetLocStringByKeyExt( "SlowdownEffect" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_stream
						+ "." + "</font>";
			}
			break;
		case 'energy_lightning':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_energy_lightning" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_energy_lightning_descr" ) + ".";
				text += "<br/>" + GetLocStringByKeyExt( "spells_one_target" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ shock_dmg
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_proj
						+ "." + "</font>";
			}
			break;
		case 'energy_cone':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_energy_cone" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_energy_cone_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ shock_dmg
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_wavefar
						+ "." + "</font>";
			}
			break;
		default :
			found = false;
			text = "";
			break;
	}
	
	return found;
}
			
function get_spellinfo_byname2( spellname : name, out text : string ) : bool
{
	var damage, elem_dmg, frost_dmg, poison_dmg, direct_dmg, shock_dmg, force_dmg, bleeding, poison, modifier, fire_dmg 		: string;
	var modifier_proj, modifier_trap, modifier_wave, modifier_stream, modifier_wavefar, modifier_trapspec, modifier_blast     	: string;
	var modifier_meteors, modifier_iceblast, modifier_meteors_quil, modifier_storm, damage_decrease, chance, burning   			: string;
	var modifier_shield, sword_attack																					: string;
	var i 									: int;
	var found								: bool;
	var item_name_quick 					: name;
	var fontItemName, fontDamage			: string;
	var xbow_name							: string;

	found = true;

	fontItemName = "<font size=\"26\" color=\"#034077\">";
	fontDamage = "<font size=\"21\">";

	damage    				= GetLocStringByKeyExt( "spells_damages_damage" )   			;
	elem_dmg  				= GetLocStringByKeyExt( "spells_elemental_damage" ) 			;
	fire_dmg 				= GetLocStringByKeyExt( "spells_fire_damage" )      			;
	frost_dmg 				= GetLocStringByKeyExt( "spells_frost_damage" )     			;
	poison_dmg  			= GetLocStringByKeyExt( "spells_poison_damage" )    			;
	direct_dmg  			= GetLocStringByKeyExt( "spells_direct_damage" )    			;
	shock_dmg 				= GetLocStringByKeyExt( "spells_shock_damage" )     			;
	force_dmg 				= GetLocStringByKeyExt( "spells_force_damage" )					;
	bleeding				= GetLocStringByKeyExt( "effect_bleeding" )						;
	poison					= GetLocStringByKeyExt( "attribute_name_poison" )				;
	burning					= GetLocStringByKeyExt( "spells_burning_descr" )				;
	modifier				= GetLocStringByKeyExt( "spells_modifier" )						;	
	modifier_proj			= GetLocStringByKeyExt( "spells_modifier_projectile" )			;	
	modifier_trap			= GetLocStringByKeyExt( "spells_modifier_trap" )				;	
	modifier_wave			= GetLocStringByKeyExt( "spells_modifier_wave" )				;	
	modifier_stream			= GetLocStringByKeyExt( "spells_modifier_stream" )				;	
	modifier_wavefar		= GetLocStringByKeyExt( "spells_modifier_wave_far" )			;	
	modifier_trapspec		= GetLocStringByKeyExt( "spells_modifier_trap_spec" )			;	
	modifier_blast			= GetLocStringByKeyExt( "spells_modifier_blast" )				;	
	modifier_meteors		= GetLocStringByKeyExt( "spells_modifier_meteors" )				;	
	modifier_iceblast		= GetLocStringByKeyExt( "spells_modifier_iceblast" )			;	
	modifier_meteors_quil	= GetLocStringByKeyExt( "spells_modifier_meteors_quileg" )		;	
	modifier_storm			= GetLocStringByKeyExt( "spells_modifier_storm" )				;	
	damage_decrease    		= GetLocStringByKeyExt( "spells_less_damage" )   				;
	chance    				= GetLocStringByKeyExt( "spells_chance" )   					;
	modifier_shield			= GetLocStringByKeyExt( "spells_modifier_shield" )				;	
	sword_attack			= GetLocStringByKeyExt( "spells_modifier_sword_attack" )		;

	switch( spellname )
	{
		case 'black_panther':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_black_panther" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_black_panther_descr" ) + ".";
			}
			break;
		case 'witch_root':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_witch_root" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_witch_root_descr" ) + ".";
				text += "<br/>" + GetLocStringByKeyExt( "spells_small_radius" ) + ".";
				text += "<br/>" + GetLocStringByKeyExt( "spells_damage_to_player" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + " " + damage_decrease + ": " 
						+ elem_dmg
						+ "."
						+ "<br/>" + chance + ": "
						+ bleeding
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_proj
						+ "." + "</font>";
			}
			break;
		case 'rootstrain':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_rootstrain" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_rootstrain_descr" ) + ".";
			}
			break;
		case 'arena_of_dancers':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_arena_of_dancers" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_arena_of_dancers_descr" ) + ".";
			}
			break;
		case 'torn_veil':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_torn_veil" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_torn_veil_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ modifier + ": "
						+ sword_attack
						+ "." + "</font>";
			}
			break;
		case 'abyss_watcher':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_abyss_watcher" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_abyss_watcher_descr" ) + ".";
			}
			break;
		case 'grave_flame':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_grave_flame" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_grave_flame_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ fire_dmg + ", "
						+ poison_dmg + ", "
						+ elem_dmg
						+ "."
						+ "<br/>" + chance + ": "
						+ burning + ", "
						+ poison + ", "
						+ GetLocStringByKeyExt( "SlowdownEffect" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_wave
						+ "." + "</font>";
			}
			break;
		case 'transference_spell':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_transference_spell" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_transference_spell_descr" ) + ".";
			}
			break;
		case 'carry_spell':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_carry_spell" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_carry_spell_descr" ) + ".";
			}
			break;
		case 'winter_souls_tornado':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_winter_souls_tornado" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_winter_souls_tornado_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ frost_dmg
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_trapspec
						+ "." + "</font>";
			}
			break;
		case 'winter_souls_shield':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_winter_souls_shield" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_winter_souls_shield_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ frost_dmg
						+ ".<br/>"
						+ chance + ": "
						+ GetLocStringByKeyExt( "spells_frozen_descr" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_shield
						+ "." + "</font>";
			}
			break;
		case 'winter_souls_stream':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_winter_souls_stream" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_winter_souls_stream_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ frost_dmg + ", "
						+ GetLocStringByKeyExt( "SlowdownEffect" )
						+ "."
						+ "<br/>" + chance + ": "
						+ GetLocStringByKeyExt( "spells_frozen_descr" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_stream
						+ "." + "</font>";
			}
			break;
		case 'winter_souls_cone':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_winter_souls_cone" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_winter_souls_cone_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ frost_dmg + ", "
						+ GetLocStringByKeyExt( "SlowdownEffect" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_wave
						+ "." + "</font>";
			}
			break;
		case 'winter_souls_blast':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_winter_souls_blast" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_winter_souls_blast_descr" ) + ".";
				text += "<br/>" + GetLocStringByKeyExt( "spells_around_targets" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ frost_dmg + ", "
						+ GetLocStringByKeyExt( "SlowdownEffect" )
						+ "."
						+ "<br/>" + chance + ": "
						+ GetLocStringByKeyExt( "spells_frozen_descr" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_blast
						+ "." + "</font>";
			}
			break;
		case 'meteor_fire':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_meteor_fire" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_meteor_fire_descr" ) + ".";
				text += "<br/>" + GetLocStringByKeyExt( "spells_small_radius" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ fire_dmg
						+ "."
						+ "<br/>" + chance + ": "
						+ burning
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_meteors
						+ "." + "</font>";
			}
			break;
		case 'meteor_frost':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_meteor_frost" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_meteor_frost_descr" ) + ".";
				text += "<br/>" + GetLocStringByKeyExt( "spells_small_radius" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ frost_dmg + ", "
						+ GetLocStringByKeyExt( "SlowdownEffect" )
						+ "."
						+ "<br/>" + chance + ": "
						+ GetLocStringByKeyExt( "spells_frozen_descr" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_meteors
						+ "." + "</font>";
			}
			break;
		case 'iceblast':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_iceblast" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_iceblast_descr" ) + ".";
				text += "<br/>" + GetLocStringByKeyExt( "spells_small_radius" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ frost_dmg + ", "
						+ GetLocStringByKeyExt( "SlowdownEffect" )
						+ "."
						+ "<br/>" + chance + ": "
						+ GetLocStringByKeyExt( "spells_frozen_descr" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_iceblast
						+ "." + "</font>";
			}
			break;
		case 'fire_vortex':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_fire_vortex" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_fire_vortex_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ fire_dmg
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_trapspec
						+ "." + "</font>";
			}
			break;
		case 'quileg_shield':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_quileg_shield" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_quileg_shield_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ fire_dmg
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_shield
						+ "." + "</font>";
			}
			break;
		case 'quileg_stream':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_quileg_stream" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_quileg_stream_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ fire_dmg + ", "
						+ burning
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_stream
						+ "." + "</font>";
			}
			break;
		case 'quileg_meteors':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_quileg_meteors" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_quileg_meteors_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ fire_dmg
						+ "."
						+ "<br/>" + chance + ": "
						+ burning
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_meteors_quil
						+ "." + "</font>";
			}
			break;
		case 'quileg_blast':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_quileg_blast" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_quileg_blast_descr" ) + ".";
				text += "<br/>" + GetLocStringByKeyExt( "spells_around_targets" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ fire_dmg
						+ "."
						+ "<br/>" + chance + ": "
						+ burning
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_blast
						+ "." + "</font>";
			}
			break;
		case 'old_gods_storm':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_old_gods_storm" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_old_gods_storm_descr" ) + ".";
				text += "<br/>" + GetLocStringByKeyExt( "spells_around_targets" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ shock_dmg
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_storm
						+ "." + "</font>";
			}
			break;
		case 'old_gods_stream':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_old_gods_stream" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_old_gods_stream_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ shock_dmg + ", "
						+ fire_dmg + ", "
						+ GetLocStringByKeyExt( "SlowdownEffect" )
						+ "."
						+ "<br/>" + chance + ": "
						+ burning
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_stream
						+ "." + "</font>";
			}
			break;
		case 'sunspear':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_sunspear" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_sunspear_descr" ) + ".";
				text += "<br/>" + GetLocStringByKeyExt( "spells_small_radius" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + " " + damage_decrease + ": " 
						+ shock_dmg + ", "
						+ fire_dmg
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_proj
						+ "." + "</font>";
			}
			break;
		case 'electric_blast':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_electric_blast" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_electric_blast_descr" ) + ".";
				text += "<br/>" + GetLocStringByKeyExt( "spells_around_targets" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + " " + damage_decrease + ": " 
						+ shock_dmg
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_blast
						+ "." + "</font>";
			}
			break;
		case 'lukatiel_sword':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_lukatiel_sword" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_lukatiel_sword_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ modifier + ": "
						+ GetLocStringByKeyExt( "spells_modifier_sword_attack" )
						+ "." + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_lukatiel_sword_add" ) + ".";
				
			}
			break;
		case 'sword_yrden_cone':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_sword_yrden_cone" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_sword_yrden_cone_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ shock_dmg + ", "
						+ GetLocStringByKeyExt( "SlowdownEffect" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ GetLocStringByKeyExt( "spells_modifier_sword" )
						+ "." + "</font>";
			}
			break;
		case 'sword_quen_cone':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_sword_quen_cone" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_sword_quen_cone_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ fire_dmg + ", "
						+ poison_dmg
						+ "."
						+ "<br/>" + chance + ": "
						+ poison
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ GetLocStringByKeyExt( "spells_modifier_sword" )
						+ "." + "</font>";
			}
			break;
		case 'sword_igni_cone':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_sword_igni_cone" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_sword_igni_cone_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ fire_dmg
						+ "."
						+ "<br/>" + chance + ": "
						+ burning
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ GetLocStringByKeyExt( "spells_modifier_sword" )
						+ "." + "</font>";
			}
			break;
		case 'sword_axii_cone':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_sword_axii_cone" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_sword_axii_cone_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ frost_dmg + ", "
						+ GetLocStringByKeyExt( "SlowdownEffect" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ GetLocStringByKeyExt( "spells_modifier_sword" )
						+ "." + "</font>";
			}
			break;
		case 'sword_aard_cone':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_sword_aard_cone" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_sword_aard_cone_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ force_dmg
						+ "."
						+ "<br/>" + chance + ": "
						+ GetLocStringByKeyExt( "spells_knockdown_descr" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ GetLocStringByKeyExt( "spells_modifier_sword" )
						+ "." + "</font>";
						
			}
			break;
		default :
			found = false;
			text = "";
			break;
	}
	
	return found;
}

function get_spellinfo_byname3( spellname : name, out text : string ) : bool
{
	var damage, elem_dmg, frost_dmg, poison_dmg, direct_dmg, shock_dmg, force_dmg, bleeding, poison, modifier, fire_dmg 		: string;
	var modifier_proj, modifier_trap, modifier_wave, modifier_stream, modifier_wavefar, modifier_trapspec, modifier_blast     	: string;
	var modifier_meteors, modifier_iceblast, modifier_meteors_quil, modifier_storm, damage_decrease, chance, burning   			: string;
	var modifier_shield, sword_attack																					: string;
	var i 									: int;
	var item_name_quick 					: name;
	var fontItemName, fontDamage			: string;
	var xbow_name							: string;
	var found 								: bool;

	found = true;

	fontItemName = "<font size=\"26\" color=\"#034077\">";
	fontDamage = "<font size=\"21\">";

	damage    				= GetLocStringByKeyExt( "spells_damages_damage" )   			;
	elem_dmg  				= GetLocStringByKeyExt( "spells_elemental_damage" ) 			;
	fire_dmg 				= GetLocStringByKeyExt( "spells_fire_damage" )      			;
	frost_dmg 				= GetLocStringByKeyExt( "spells_frost_damage" )     			;
	poison_dmg  			= GetLocStringByKeyExt( "spells_poison_damage" )    			;
	direct_dmg  			= GetLocStringByKeyExt( "spells_direct_damage" )    			;
	shock_dmg 				= GetLocStringByKeyExt( "spells_shock_damage" )     			;
	force_dmg 				= GetLocStringByKeyExt( "spells_force_damage" )					;
	bleeding				= GetLocStringByKeyExt( "effect_bleeding" )						;
	poison					= GetLocStringByKeyExt( "attribute_name_poison" )				;
	burning					= GetLocStringByKeyExt( "spells_burning_descr" )				;
	modifier				= GetLocStringByKeyExt( "spells_modifier" )						;	
	modifier_proj			= GetLocStringByKeyExt( "spells_modifier_projectile" )			;	
	modifier_trap			= GetLocStringByKeyExt( "spells_modifier_trap" )				;	
	modifier_wave			= GetLocStringByKeyExt( "spells_modifier_wave" )				;	
	modifier_stream			= GetLocStringByKeyExt( "spells_modifier_stream" )				;	
	modifier_wavefar		= GetLocStringByKeyExt( "spells_modifier_wave_far" )			;	
	modifier_trapspec		= GetLocStringByKeyExt( "spells_modifier_trap_spec" )			;	
	modifier_blast			= GetLocStringByKeyExt( "spells_modifier_blast" )				;	
	modifier_meteors		= GetLocStringByKeyExt( "spells_modifier_meteors" )				;	
	modifier_iceblast		= GetLocStringByKeyExt( "spells_modifier_iceblast" )			;	
	modifier_meteors_quil	= GetLocStringByKeyExt( "spells_modifier_meteors_quileg" )		;	
	modifier_storm			= GetLocStringByKeyExt( "spells_modifier_storm" )				;	
	damage_decrease    		= GetLocStringByKeyExt( "spells_less_damage" )   				;
	chance    				= GetLocStringByKeyExt( "spells_chance" )   					;
	modifier_shield			= GetLocStringByKeyExt( "spells_modifier_shield" )				;	
	sword_attack			= GetLocStringByKeyExt( "spells_modifier_sword_attack" )		;

	switch( spellname )
	{
		case 'blood_moon_trap':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_blood_moon_trap" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_blood_moon_trap_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ direct_dmg
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_trapspec
						+ "." + "</font>";
			}
			break;
		case 'valerie_stream':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_valerie_stream" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_valerie_stream_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ direct_dmg
						+ "."
						+ "<br/>" + chance + ": "
						+ GetLocStringByKeyExt( "SlowdownEffect" )
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_stream
						+ "." + "</font>";
			}
			break;
		case 'valerie_devour':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_valerie_devour" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_valerie_devour_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ direct_dmg
						+ "." + "</font>";
			}
			break;
		case 'blood_cone':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_blood_cone" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_blood_cone_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ bleeding
						+ "." + "</font>";
			}
			break;
		case 'assassin_tornado':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_assassin_tornado" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_assassin_tornado_descr" ) + ".";
				text += "<br/>" + fontDamage + "" 
						+ damage + ": " 
						+ elem_dmg
						+ ".";
				text += "<br/>"
						+ modifier + ": "
						+ modifier_trapspec
						+ "." + "</font>";
			}
			break;
		case 'assassin_bless':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_assassin_bless" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_assassin_bless_descr" ) + ".";
			}
			break;
		case 'assassin_curse':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_assassin_curse" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_assassin_curse_descr" ) + ".";
			}
			break;
		case 'storm_slow':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_storm_slow" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_storm_slow_descr" ) + ".";
			}
			break;
		case 'invisibility_spell':
			{
				text += fontItemName + GetLocStringByKeyExt( "spells_invisibility_spell" ) + "</font>";
				text += "<br/>" + GetLocStringByKeyExt( "spells_invisibility_spell_descr" ) + ".";
			}
			break;
		default :
			found = false;
			text = "";
			break;
	}
	
	return found;
}

function get_spellinfo_lukatiel( spellname : string, out text : string )
{
	var damage, elem_dmg, frost_dmg, poison_dmg, direct_dmg, shock_dmg, force_dmg, bleeding, poison, modifier, fire_dmg 		: string;
	var modifier_proj, modifier_trap, modifier_wave, modifier_stream, modifier_wavefar, modifier_trapspec, modifier_blast     	: string;
	var modifier_meteors, modifier_iceblast, modifier_meteors_quil, modifier_storm, damage_decrease, chance, burning   			: string;
	var modifier_shield, sword_attack																					: string;
	var i 									: int;
	var item_name_quick 					: name;
	var fontItemName, fontDamage			: string;
	var xbow_name							: string;
	var found 								: bool;

	fontItemName = "<font size=\"26\" color=\"#034077\">";
	fontDamage = "<font size=\"21\">";

	damage    				= GetLocStringByKeyExt( "spells_damages_damage" )   			;
	elem_dmg  				= GetLocStringByKeyExt( "spells_elemental_damage" ) 			;
	fire_dmg 				= GetLocStringByKeyExt( "spells_fire_damage" )      			;
	frost_dmg 				= GetLocStringByKeyExt( "spells_frost_damage" )     			;
	poison_dmg  			= GetLocStringByKeyExt( "spells_poison_damage" )    			;
	direct_dmg  			= GetLocStringByKeyExt( "spells_direct_damage" )    			;
	shock_dmg 				= GetLocStringByKeyExt( "spells_shock_damage" )     			;
	force_dmg 				= GetLocStringByKeyExt( "spells_force_damage" )					;
	bleeding				= GetLocStringByKeyExt( "effect_bleeding" )						;
	poison					= GetLocStringByKeyExt( "attribute_name_poison" )				;
	burning					= GetLocStringByKeyExt( "spells_burning_descr" )				;
	modifier				= GetLocStringByKeyExt( "spells_modifier" )						;	
	modifier_proj			= GetLocStringByKeyExt( "spells_modifier_projectile" )			;	
	modifier_trap			= GetLocStringByKeyExt( "spells_modifier_trap" )				;	
	modifier_wave			= GetLocStringByKeyExt( "spells_modifier_wave" )				;	
	modifier_stream			= GetLocStringByKeyExt( "spells_modifier_stream" )				;	
	modifier_wavefar		= GetLocStringByKeyExt( "spells_modifier_wave_far" )			;	
	modifier_trapspec		= GetLocStringByKeyExt( "spells_modifier_trap_spec" )			;	
	modifier_blast			= GetLocStringByKeyExt( "spells_modifier_blast" )				;	
	modifier_meteors		= GetLocStringByKeyExt( "spells_modifier_meteors" )				;	
	modifier_iceblast		= GetLocStringByKeyExt( "spells_modifier_iceblast" )			;	
	modifier_meteors_quil	= GetLocStringByKeyExt( "spells_modifier_meteors_quileg" )		;	
	modifier_storm			= GetLocStringByKeyExt( "spells_modifier_storm" )				;	
	damage_decrease    		= GetLocStringByKeyExt( "spells_less_damage" )   				;
	chance    				= GetLocStringByKeyExt( "spells_chance" )   					;
	modifier_shield			= GetLocStringByKeyExt( "spells_modifier_shield" )				;	
	sword_attack			= GetLocStringByKeyExt( "spells_modifier_sword_attack" )		;


	switch( spellname )
	{
		case "Yrden":
			{
				if ( thePlayer.CanUseSkill(S_Sword_s02) && is_holding_sword_spells() )
				{
					text += "<br/><br/>";
					text += "<font face=\"$BoldFont\">" + GetLocStringByKeyExt( "skill_name_sword_s2" ) + "</font>";
					text += "<br/>";
					text += fontItemName + GetLocStringByKeyExt( "spells_sword_yrden_rend" ) + "</font>";
					text += "<br/>" + fontDamage + "" 
							+ damage + " " + GetLocStringByKeyExt( "spells_sword_rend_damage" ) + ": " 
							+ shock_dmg
							+ ".";
					text += "<br/>"
							+ modifier + ": "
							+ modifier_wavefar
							+ "." + "</font>";
				}
						
				if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'enable_crossbow_effects') )
				{
					if ( spells_has_crossbow_equipped( xbow_name ) )
					{
						text += "<br/><br/>";
						text += "<font face=\"$BoldFont\">" + xbow_name + "</font>";
						text += "<br/>";
						text += fontItemName + GetLocStringByKeyExt( "spells_sword_yrden_xbow" ) + "</font>";
						text += "<br/>" + GetLocStringByKeyExt( "spells_small_radius" ) + ".";
						text += "<br/>" + fontDamage + "" 
								+ damage + ": " 
								+ shock_dmg
								+ ".";
						text += "<br/>"
								+ modifier + ": "
								+ modifier_proj + ", " + GetLocStringByKeyExt( "spells_modifier_xbow" )
								+ "." + "</font>";
								
					}
				}
			}
			break;
		case "Quen":
			{
				if ( thePlayer.CanUseSkill(S_Sword_s02) && is_holding_sword_spells() )
				{
					text += "<br/><br/>";
					text += "<font face=\"$BoldFont\">" + GetLocStringByKeyExt( "skill_name_sword_s2" ) + "</font>";
					text += "<br/>";
					text += fontItemName + GetLocStringByKeyExt( "spells_sword_quen_rend" ) + "</font>";
					text += "<br/>" + fontDamage + "" 
							+ damage + " " + GetLocStringByKeyExt( "spells_sword_rend_damage" ) + ": " 
							+ poison_dmg
							+ "."
							+ "<br/>" + chance + ": "
							+ poison
							+ ".";
					text += "<br/>"
							+ modifier + ": "
							+ modifier_wavefar
							+ "." + "</font>";
				}
						
				if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'enable_crossbow_effects') )
				{
					if ( spells_has_crossbow_equipped( xbow_name ) )
					{
						text += "<br/><br/>";
						text += "<font face=\"$BoldFont\">" + xbow_name + "</font>";
						text += "<br/>";
						text += fontItemName + GetLocStringByKeyExt( "spells_sword_quen_xbow" ) + "</font>";
						text += "<br/>" + GetLocStringByKeyExt( "spells_sword_quen_xbow_descr" ) + ".";
						text += "<br/>" + fontDamage + "" 
								+ damage + ": " 
								+ shock_dmg
								+ ".";
						text += "<br/>"
								+ modifier + ": "
								+ modifier_wavefar + ", " + GetLocStringByKeyExt( "spells_modifier_xbow" )
								+ "." + "</font>";
					}
				}
			}
			break;
		case "Igni":
			{
				if ( thePlayer.CanUseSkill(S_Sword_s02) && is_holding_sword_spells() )
				{
					text += "<br/><br/>";
					text += "<font face=\"$BoldFont\">" + GetLocStringByKeyExt( "skill_name_sword_s2" ) + "</font>";
					text += "<br/>";
					text += fontItemName + GetLocStringByKeyExt( "spells_sword_igni_rend" ) + "</font>";
					text += "<br/>" + fontDamage + "" 
							+ damage + " " + GetLocStringByKeyExt( "spells_sword_rend_damage" ) + ": " 
							+ fire_dmg
							+ "."
							+ "<br/>" + chance + ": "
							+ burning
							+ ".";
					text += "<br/>"
							+ modifier + ": "
							+ modifier_wavefar
							+ "." + "</font>";
				}
					
				if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'enable_crossbow_effects') )
				{
					if ( spells_has_crossbow_equipped( xbow_name ) )
					{
						text += "<br/><br/>";
						text += "<font face=\"$BoldFont\">" + xbow_name + "</font>";
						text += "<br/>";
						text += fontItemName + GetLocStringByKeyExt( "spells_sword_igni_xbow" ) + "</font>";
						text += "<br/>" + GetLocStringByKeyExt( "spells_pierce_target" ) + ".";
						text += "<br/>" + fontDamage + "" 
								+ damage + ": " 
								+ fire_dmg
								+ "."
								+ "<br/>" + chance + ": "
								+ burning
								+ ".";
						text += "<br/>"
								+ modifier + ": "
								+ modifier_proj + ", " + GetLocStringByKeyExt( "spells_modifier_xbow" )
								+ "." + "</font>";
					}
				}
			}
			break;
		case "Axii":
			{
				if ( thePlayer.CanUseSkill(S_Sword_s02) && is_holding_sword_spells() )
				{
					text += "<br/><br/>";
					text += "<font face=\"$BoldFont\">" + GetLocStringByKeyExt( "skill_name_sword_s2" ) + "</font>";
					text += "<br/>";
					text += fontItemName + GetLocStringByKeyExt( "spells_sword_axii_rend" ) + "</font>";
					text += "<br/>" + fontDamage + "" 
							+ damage + " " + GetLocStringByKeyExt( "spells_sword_rend_damage" ) + ": " 
							+ frost_dmg + ", "
							+ GetLocStringByKeyExt( "SlowdownEffect" )
							+ "."
							+ "<br/>" + chance + ": "
							+ GetLocStringByKeyExt( "spells_frozen_descr" )
							+ ".";
					text += "<br/>"
							+ modifier + ": "
							+ modifier_wavefar
							+ "." + "</font>";
				}
						
				if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'enable_crossbow_effects') )
				{
					if ( spells_has_crossbow_equipped( xbow_name ) )
					{
						text += "<br/><br/>";
						text += "<font face=\"$BoldFont\">" + xbow_name + "</font>";
						text += "<br/>";
						text += fontItemName + GetLocStringByKeyExt( "spells_sword_axii_xbow" ) + "</font>";
						text += "<br/>" + GetLocStringByKeyExt( "spells_small_radius" ) + ".";
						text += "<br/>" + fontDamage + "" 
								+ damage + ": " 
								+ GetLocStringByKeyExt( "SlowdownEffect" )
								+ "." + "</font>";
					}
				}
			}
			break;
		case "Aard":
			{
				if ( thePlayer.CanUseSkill(S_Sword_s02) && is_holding_sword_spells() )
				{
					text += "<br/><br/>";
					text += "<font face=\"$BoldFont\">" + GetLocStringByKeyExt( "skill_name_sword_s2" ) + "</font>";
					text += "<br/>";
					text += fontItemName + GetLocStringByKeyExt( "spells_sword_aard_rend" ) + "</font>";
					text += "<br/>" + fontDamage + "" 
							+ damage + " " + GetLocStringByKeyExt( "spells_sword_rend_damage" ) + ": " 
							+ force_dmg
							+ "."
							+ "<br/>" + chance + ": "
							+ bleeding + ", "
							+ GetLocStringByKeyExt( "spells_knockdown_descr" )
							+ ".";
					text += "<br/>"
							+ modifier + ": "
							+ modifier_wavefar
							+ "." + "</font>";
				}
				
				if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'enable_crossbow_effects') )
				{
					if ( spells_has_crossbow_equipped( xbow_name ) )
					{
						text += "<br/><br/>";
						text += "<font face=\"$BoldFont\">" + xbow_name + "</font>";
						text += "<br/>";
						text += fontItemName + GetLocStringByKeyExt( "spells_sword_aard_xbow" ) + "</font>";
						text += "<br/>" + GetLocStringByKeyExt( "spells_pierce_target" ) + ".";
						text += "<br/>" + fontDamage + "" 
								+ damage + ": " 
								+ force_dmg + ", "
								+ bleeding
								+ "."
								+ "<br/>" + chance + ": "
								+ GetLocStringByKeyExt( "spells_knockdown_descr" )
								+ ".";
						text += "<br/>"
								+ modifier + ": "
								+ modifier_proj + ", " + GetLocStringByKeyExt( "spells_modifier_xbow" )
								+ "." + "</font>";
					}
				}
			}
			break;
		default:		
			break;
	}
}
